<!DOCTYPE html>
<html>
  <head>
    <meta charset='utf8'/>
    <title>Videos</title>
  </head>
  <body>
<?php
$mp4s = array_merge(glob("*.mp4"),glob("*.m4a"),glob("*.mp3"));
$mp4ds = glob("*/");
echo "<section>\n";
echo "<h1>/</h1>\n";
echo "<ul>\n";
foreach($mp4s as $mp4) {
  echo "<li><a href='stream.php?$mp4'>$mp4</a></li>\n";
}
echo "</ul>\n";
echo "</section>\n";

foreach($mp4ds as $d) {
  $d = rtrim($d,"/");
  $xs = array_merge(glob("$d/*.mp4"),glob("$d/*.m4a"),glob("$d/*.mp3"));
  if( count($xs) > 0 ) {
    echo "<section class='collapse'>\n";
    echo "<h1>$d</h1>\n";
    if( count($xs) > 1 ) {
      echo "<p><a href='playlist.php?$d' class='playlist'>$d.m3u</a></p>\n";
    }
    echo "<ul>\n";
    foreach($xs as $mp4) {
      echo "<li><a href='stream.php?$mp4'>$mp4</a></li>\n";
    }
    echo "</ul>\n";
    echo "</section>\n";
  }
}

?>
  </body>
<script>

window.q = (x,y=document) => y.querySelector(x)
window.qq = (x,y=document) => Array.from(y.querySelectorAll(x))

function acms(e) {
    let key = e.key
    const code = e.code.toLowerCase()
    if( code === "backquote" ) { key = "`" }
    if( code.startsWith("digit") ) { key = code.substr(5) }
    if( code === "space" ) { key = "space" }
    let t = key.toLowerCase()
    if( e.shiftKey ) t = "S-"+t
    if( e.metaKey ) t = "M-"+t
    if( e.ctrlKey ) t = "C-"+t
    if( e.altKey ) t = "A-"+t
    return t
}

const sections = qq("section")
sections.forEach( s => {
  const h1 = q("h1",s)
  if( h1 ) {
    h1.addEventListener("click", e => {
      e.preventDefault()
      s.classList.toggle("collapse")
    })
  }
})
</script>
<style>
body {
  background-color: #007;
}
section.collapse {
  background-color: #ccc;
}
section.collapse ul {
  display: none;
}
section.collapse p {
  display: none;
}
section p {
  padding-left: 1rem;
}
section ul {
  list-style-type: none;
}
section {
  position: relative;
  padding: 0.3rem;
  margin: 0.5rem;
  border: 1px solid black;
  box-shadow: 0.5rem 0.5rem 0.5rem black;
  background-color: white;
  color: black;
}
section h1 {
  width: 100%;
  cursor: pointer;
}
section h1:hover {
  color: #070;
}
section.collapse:hover {
  background-color: #dfd;
}

a {
  text-decoration: none;
}

/* Media */
a[href$=mp3] {
  color: #700;
}
a[href$=m4a] {
  color: #070;
}
a[href$=mp4] {
  color: #007;
}
a[href$=mp3]::before {
  content: "🎵 ";
}
a[href$=m4a]::before {
  content: "🎵 ";
}
a[href$=mp4]::before {
  content: "🎥 ";
}

/* Playlist */
a.playlist {
  color: #505;
}
a.playlist::before {
  content: "🎶 ";
}
  
</style>
</html>

